package com.inet.samples.factory;

import java.util.Properties;

import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.report.cache.EngineFactory;
import com.inet.report.cache.EngineFactoryImpl;
import com.inet.report.cache.ReportCacheKey;

/**
 * A sample implementation of the EngineFactory interface.
 */
public class CustomEngineFactory extends EngineFactoryImpl implements EngineFactory {

    /**
     * {@inheritDoc}
     */
    @Override
    public Engine createEngine( Properties requestProps ) throws ReportException {
        // create the real properties for rendering. For example replace a symbolic report file name with a real file name.
        Properties reportingProperties = (Properties)requestProps.clone();
        // reportingProperties.setProperty( "report", "/MyHiddenPath/" + requestProps.getProperty( "report" ) );

        // The call to super.createEngine:
        // * creates a new Engine for the given format
        // * loads the rpt template file
        // * sets the prompts
        // * sets further URL parameters
        // * sets the properties as user properties
        Engine eng = super.createEngine( reportingProperties );

        // Use the original properties for the generation of links in the report (images, drill down) to hide the real properties
        eng.setUserProperties( requestProps );
        return eng;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ReportCacheKey getKey( Properties props ) throws ReportException {
        return super.getKey( props );
    }
}
